USE [BMS_DS]
GO
/****** Object:  UserDefinedFunction [dbo].[ufn_ETL_Fact_Waiting_List]    Script Date: 4/29/2016 12:44:15 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER function [dbo].[ufn_ETL_Fact_Waiting_List](@START_DATE DATETIME, @END_DATE DATETIME)
RETURNS TABLE 
AS
RETURN
(
	SELECT  
		   ACT.ID AS SOURCE_ID,
		   CAST(WAITING_LIST.FACILITY_UID AS NVARCHAR(250))  AS FACILITY_ID,
		   CAST(WAITING_LIST.VISTA_SITE_UID AS NVARCHAR(250)) AS VISTA_SITE_ID,
		   CONCEPT_WAITING_AREA.CODE AS WAITING_AREA_CODE,
		   WAITING_LIST.PROBLEM AS PROBLEM,
		   CONCEPT_FEE_DISPOSITION.CODE AS FEE_DISPOSITION_CODE,
		   CONCEPT_CONTRACT_FEE.CODE AS CONTRACT_FEE_CODE,
		   CONCEPT_AUTHORIZED_FEE.CODE AS AUTHORIZED_FEE_CODE,
		   CONCEPT_SERVICE_RECEIVING_FEE.CODE AS SERVICE_RECEIVING_FEE_CODE,
		   CONCEPT_REASON_USING_FEE.CODE AS DIM_REASON_USING_FEE_CODE,
		   WAITING_LIST.FEE_COMMENTS AS FEE_COMMENTS,
		   WAITING_LIST.REMOVED_DATE AS REMOVED_DATE,
		   WAITING_LIST.TYPE_OF_BED_WARD AS TYPE_OF_BED_WARD,
		   CAST(WAITING_LIST.REQUESTED_BED_UID AS NVARCHAR(250)) as REQUESTED_BED_ID,
		   WAITING_LIST.REQUESTED_BED_DATE AS REQUESTED_BED_DATE,
		   WAITING_LIST.REQUESTED_DATE AS REQUESTED_DATE,
		   ACT._ssis_timestamp AS _SSIS_TIMESTAMP,
		   [WAITING_LIST].[IS_IN_HOUSE] AS [IS_IN_HOUSE],
		   [WAITING_LIST].[LAST_EDIT_BY] AS [LAST_EDIT_BY],
		   [WAITING_LIST].[COMMENTS] AS [COMMENTS],
		   [WAITING_LIST].[IS_BED_IN_ISOLATION] AS IS_BED_IN_ISOLATION,
		   [WAITING_LIST].[WAIT_TIME_ALERT_DATE] AS WAIT_TIME_ALERT_DATE,
		   [WAITING_LIST].[IS_COMMUNITY_LIVING_CENTER] AS [IS_COMMUNITY_LIVING_CENTER],
		   [WAITING_LIST].[IS_EVACUATION_PATIENT] AS [IS_EVACUATION_PATIENT],
		   [CONCEPT_EVACUATION_DISPOSITION_STATUS].[CODE] AS [EVACUATION_DISPOSITION_STATUS_CODE],
		   [WAITING_LIST].[EVACUATION_EXPECTED_DATE] AS [EVACUATION_EXPECTED_DATE],
		   [WAITING_LIST].[EVACUATION_ACTUAL_DATE] AS [EVACUATION_ACTUAL_DATE],
		   [WAITING_LIST].[EVACUATION_REASON_FOR_DELAY] AS [EVACUATION_REASON_FOR_DELAY],
		   [WAITING_LIST].[EVACUATION_TRANSFER_EVACUATE_TO] AS [EVACUATION_TRANSFER_EVACUATE_TO],
		   [WAITING_LIST].[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] AS [EVACUATION_EQUIP_SUPPLY_REQUIREMENTS],
		   [WAITING_LIST].[EVACUATION_TRANSPORTATION_CARE_LEVEL] AS [EVACUATION_TRANSPORTATION_CARE_LEVEL],
		   [WAITING_LIST].[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] AS [EVACUATION_ENROUTE_MEDICAL_ATTENDANT],
		   [WAITING_LIST].[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] AS [EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
		   [CONCEPT_EVACUATION_TRANSPORTATION_TYPE].[CODE] AS [EVACUATION_TRANSPORTATION_TYPE_CODE],
		   [CONCEPT_EVACUATION_TRANSPORTATION_PROVIDER].[CODE] AS [EVACUATION_TRANSPORTATION_PROVIDER_CODE],
		   [WAITING_LIST].[EVACUATION_TRANSPORTATION_COMMENTS] AS [EVACUATION_TRANSPORTATION_COMMENTS],
		   [WAITING_LIST].[EVACUATION_DESTINATION_ADDRESS] AS [EVACUATION_DESTINATION_ADDRESS],
		   [WAITING_LIST].[EVACUATION_DESTINATION_CITY_STATE] AS [EVACUATION_DESTINATION_CITY_STATE],
		   [WAITING_LIST].[EVACUATION_DESTINATION_POC_TELEPHONE] AS [EVACUATION_DESTINATION_POC_TELEPHONE],
		   [WAITING_LIST].[EVACUATION_ORIGINATOR_POC_TELEPHONE] AS [EVACUATION_ORIGINATOR_POC_TELEPHONE],
		   [WAITING_LIST].[EVACUATION_COMMENTS] AS [EVACUATION_COMMENTS],
		   [WAITING_LIST].[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] AS EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, 
		   [WAITING_LIST].[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] AS EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
		   CAST(ACT.PATIENT_UID AS NVARCHAR(250)) AS DIM_PATIENT_ID,  
		   [WAITING_LIST].[EVACUATION_ARRIVAL_TIME] AS EVACUATION_ARRIVAL_TIME,
		   [WAITING_LIST].[EVACUATION_VEHICLE_ID] AS EVACUATION_VEHICLE_ID,
		   [WAITING_LIST].[EVACUATION_VEHICLE_SEAT_POSITION] AS EVACUATION_VEHICLE_SEAT_POSITION,
		   [WAITING_LIST].EVACUATION_MA_TELEPHONE,
		   [WAITING_LIST].EVACUATION_NMA_TELEPHONE,
		   [WAITING_LIST].EVACUATION_ORIGINATING_FACILITY_NAME,
		   [WAITING_LIST].EVACUATION_ORIGINATING_ADDRESS,
		   [WAITING_LIST].EVACUATION_ORIGINATING_CITY_STATE,
		   [WAITING_LIST].EVACUATION_VEHICLE_OPERATOR_NAME,
		   [WAITING_LIST].EVACUATION_VEHICLE_OPERATOR_TELEPHONE

	FROM BMS_ACT AS ACT
		INNER JOIN BMS_WAITING_LIST  AS WAITING_LIST ON WAITING_LIST.ACT_ID = ACT.ID AND WAITING_LIST._ISDELETED = 0 
		LEFT JOIN BMS_CONCEPT AS CONCEPT_WAITING_AREA ON CONCEPT_WAITING_AREA.ID = WAITING_LIST.WAITING_AREA_ID AND CONCEPT_WAITING_AREA._isDeleted = 0
		LEFT JOIN BMS_CONCEPT AS CONCEPT_FEE_DISPOSITION ON CONCEPT_FEE_DISPOSITION.ID = WAITING_LIST.FEE_DISPOSITION_ID AND CONCEPT_FEE_DISPOSITION._isDeleted = 0	
		LEFT JOIN BMS_CONCEPT AS CONCEPT_CONTRACT_FEE ON CONCEPT_CONTRACT_FEE.ID = WAITING_LIST.CONTRACT_FEE_ID AND CONCEPT_CONTRACT_FEE._isDeleted = 0		
		LEFT JOIN BMS_CONCEPT AS CONCEPT_AUTHORIZED_FEE ON CONCEPT_AUTHORIZED_FEE.ID = WAITING_LIST.AUTHORIZED_FEE_ID AND CONCEPT_AUTHORIZED_FEE._isDeleted = 0
		LEFT JOIN BMS_CONCEPT AS CONCEPT_SERVICE_RECEIVING_FEE ON CONCEPT_SERVICE_RECEIVING_FEE.ID = WAITING_LIST.SERVICE_RECEIVING_FEE_ID AND CONCEPT_SERVICE_RECEIVING_FEE._isDeleted = 0
		LEFT JOIN BMS_CONCEPT AS CONCEPT_REASON_USING_FEE ON CONCEPT_REASON_USING_FEE.ID = WAITING_LIST.REASON_USING_FEE_ID AND CONCEPT_REASON_USING_FEE._isDeleted = 0	
				
		LEFT JOIN BMS_CONCEPT AS CONCEPT_EVACUATION_TRANSPORTATION_PROVIDER ON CONCEPT_EVACUATION_TRANSPORTATION_PROVIDER.ID = WAITING_LIST.EVACUATION_TRANSPORTATION_PROVIDER_ID AND CONCEPT_EVACUATION_TRANSPORTATION_PROVIDER._isDeleted = 0	
		LEFT JOIN BMS_CONCEPT AS CONCEPT_EVACUATION_TRANSPORTATION_TYPE ON CONCEPT_EVACUATION_TRANSPORTATION_TYPE.ID = WAITING_LIST.EVACUATION_TRANSPORTATION_TYPE_ID AND CONCEPT_EVACUATION_TRANSPORTATION_TYPE._isDeleted = 0	
		LEFT JOIN BMS_CONCEPT AS CONCEPT_EVACUATION_DISPOSITION_STATUS ON CONCEPT_EVACUATION_DISPOSITION_STATUS.ID = WAITING_LIST.EVACUATION_DISPOSITION_STATUS_ID AND CONCEPT_EVACUATION_DISPOSITION_STATUS._isDeleted = 0		
	WHERE ACT.[_isDeleted] = 0 AND ACT.[_ssis_timestamp] > @START_DATE AND ACT.[_ssis_timestamp] < @END_DATE
)
